Use Windows.pkg
Use DFClient.pkg

Use cMyLibXLWithFormats.pkg
Use cTextEdit.pkg
Use cCJGrid.pkg
Use cCJGridColumnRowIndicator.pkg
Use cCJGridColumn.pkg
Use ShellExecute.Pkg

Deferred_View Activate_oTabelleExtras for ;
Object oTabelleExtras is a dbView
    Set Border_Style to Border_Thick
    Set Size to 231 300
    Set Location to 2 2
    Set Label to "8. Tabelle Extras"

    Property String[][] psArrayValues

    Function CMToInch Global Number nCM Returns Number
        Function_Return (nCM / 2.545454)
    End_Function // CMToInch
    
    Object oLibXL is a cMyLibXLWithFormats
    End_Object            

    Object oButtonTabelleSchreibenXLS is a Button
        Set Size to 14 104
        Set Location to 13 15
        Set Label to "XLS Schreiben"
        
        Object oLibXL is a cMyLibXL
        End_Object
        
        Procedure OnClick
            String sFileName
            Handle hoBook hoSheet
            Boolean bFileExists
            
            Move ( (psDirectory(Self)) + "Extras-XLS.xls" ) to sFileName
            
            // Alte Xls lschen
            File_Exist sFileName bFileExists
            If (bFileExists) Begin
                EraseFile sFileName
            End
            
            // Datei erstellen
            Get CreateBook of oLibXL to hoBook
            // Sheet erstellen
            Get AddSheet of hoBook "Blatt 1" to hoSheet

            // Spaltenbreite festlegen
            Set piColumnWidth of hoSheet 0 to 50    
            Set piColumnWidth of hoSheet 1 to 50    
            Set piColumnWidth of hoSheet 2 to 50    
            Set piColumnWidth of hoSheet 3 to 50    
            
            // Inhalte
            Send WriteString of hoSheet 0 0 "A1 Dataflex Entwicklertag"
            Send WriteString of hoSheet 0 1 "B1 Dataflex Entwicklertag"
            Send WriteString of hoSheet 0 2 "C1 Dataflex Entwicklertag"
            Send WriteString of hoSheet 0 3 "D1 Dataflex Entwicklertag"

            Send WriteString of hoSheet 1 0 "A2 Dataflex Entwicklertag"
            Send WriteString of hoSheet 1 1 "B2 Dataflex Entwicklertag"
            Send WriteString of hoSheet 1 2 "C2 Dataflex Entwicklertag"
            Send WriteString of hoSheet 1 3 "D1 Dataflex Entwicklertag"

            Send SaveAs of hoBook sFileName
            Send destroy to hoBook
            Send Info_Box ("Die Datei" * sFileName * "wurde erstellt")
        End_Procedure
    End_Object

    Object oButtonXLSLesen is a Button
        Set Size to 14 104
        Set Location to 13 125
        Set Label to "XLS Lesen"
    
        Procedure OnClick
            String sFileName sValue
            String[][] sArrayValues
            Handle hoBook hoSheet hoSheets
            Integer iCol iCols iRow iRows
            
            Move ( (psDirectory(Self)) + "Extras-XLS.xls" ) to sFileName
            
            Get Load of oLibXL sFileName to hoBook
            If (hoBook = 0) Begin
                Send Stop_Box ("Die Datei\n\n" + sFileName + "\n\nkonnte nicht gefunden werden") 
                Procedure_Return
            End
            If (hoBook <> 0) Begin
            Send Info_Box ("Die Datei" * sFileName * "wurde geffnet")
                Send Destroy of hoBook
                Set psArrayValues to sArrayValues
            End
        End_Procedure
    End_Object

    Object oButtonXLSOeffnen is a Button
        Set Location to 13 235
        Set Label to 'XLS ffnen'
    
        Procedure OnClick
            Handle hWnd hInstance
            String sFileName

            Move ( (psDirectory(Self)) + "Extras-XLS.xls" ) to sFileName
            Move (ShellExecute (hWnd, "open", sFileName, '', '', 0)) to hInstance
        End_Procedure
    End_Object

    Object oButtonTabelleSchreibenXLSX is a Button
        Set Size to 14 104
        Set Location to 31 15
        Set Label to "XLSX Schreiben"
        
        Object oLibXL is a cMyLibXL
        End_Object
        
        Procedure OnClick
            String sFileName
            Handle hoBook hoSheet 
            Boolean bFileExists
            
            Move ( (psDirectory(Self)) + "Extras-XLS.xlsx" ) to sFileName
            
            // Alte Xls lschen
            File_Exist sFileName bFileExists
            If (bFileExists) Begin
                EraseFile sFileName
            End
            
            // Datei erstellen
            Get CreateXMLBook of oLibXL to hoBook
            // Sheet erstellen
            Get AddSheet of hoBook "Blatt 1" to hoSheet

            // Spaltenbreite festlegen
            Set piColumnWidth of hoSheet 0 to 50    
            Set piColumnWidth of hoSheet 1 to 50    
            Set piColumnWidth of hoSheet 2 to 50    
            Set piColumnWidth of hoSheet 3 to 50    
            
            // Inhalte
            Send WriteString of hoSheet 0 0 "A1 Dataflex Entwicklertag"
            Send WriteString of hoSheet 0 1 "B1 Dataflex Entwicklertag"
            Send WriteString of hoSheet 0 2 "C1 Dataflex Entwicklertag"
            Send WriteString of hoSheet 0 3 "D1 Dataflex Entwicklertag"

            Send WriteString of hoSheet 1 0 "A2 Dataflex Entwicklertag"
            Send WriteString of hoSheet 1 1 "B2 Dataflex Entwicklertag"
            Send WriteString of hoSheet 1 2 "C2 Dataflex Entwicklertag"
            Send WriteString of hoSheet 1 3 "D1 Dataflex Entwicklertag"

            Send SaveAs of hoBook sFileName
            Send destroy to hoBook
            Send Info_Box ("Die Datei" * sFileName * "wurde erstellt")
        End_Procedure
    End_Object

    Object oButtonXLSXLesen is a Button
        Set Size to 14 104
        Set Location to 31 125
        Set Label to "XLSX Lesen"
    
        Procedure OnClick
            String sFileName sValue
            String[][] sArrayValues
            Handle hoBook hoSheet hoSheets
            Integer iCol iCols iRow iRows
            
            Move ( (psDirectory(Self)) + "Extras-XLS.xlsx" ) to sFileName
            
            Get Load of oLibXL sFileName to hoBook
            If (hoBook = 0) Begin
                Send Stop_Box ("Die Datei\n\n" + sFileName + "\n\nkonnte nicht gefunden werden") 
                Procedure_Return
            End
            If (hoBook <> 0) Begin
            Send Info_Box ("Die Datei" * sFileName * "wurde geffnet")
                Send Destroy of hoBook
                Set psArrayValues to sArrayValues
            End
        End_Procedure
    End_Object

    Object oButtonXLSXOeffnen is a Button
        Set Location to 31 235
        Set Label to "XLSX ffnen"
    
        Procedure OnClick
            Handle hWnd hInstance
            String sFileName

            Move ( (psDirectory(Self)) + "Extras-XLS.xlsx" ) to sFileName
            Move (ShellExecute (hWnd, "open", sFileName, '', '', 0)) to hInstance
        End_Procedure
    End_Object

    Object oButtonWeitereFunktionen is a Button
        Set Size to 14 104
        Set Location to 52 15
        Set Label to "Weitere Funktionen"
        
        Object oLibXL is a cMyLibXL
        End_Object
        
        Procedure OnClick
            String sFileName
            Handle hoBook hoSheet hoCell 
            Boolean bFileExists
            
            Move ( (psDirectory(Self)) + "Extras-XLS.xlsx" ) to sFileName
            
            // Alte Xls lschen
            File_Exist sFileName bFileExists
            If (bFileExists) Begin
                EraseFile sFileName
            End
            
            // Datei erstellen
            Get CreateXMLBook of oLibXL to hoBook
            // RGB Modus aktivieren
            Set pbRgbMode of hoBook to True
            // Sheet erstellen
            Get AddSheet of hoBook "Blatt 1" to hoSheet
            // Gitter deaktivieren
            Set pbDisplayGridlines of hoSheet to False

            // Schriftartenformate festlegen
            Handle hoFont12 hoFont18
            
            Get AddFont of hoBook "Arial" 12 to hoFont12
            Get AddFont of hoBook "Arial" 18 to hoFont18
            Set pbBold of hoFont18 to True
            Set pbItalic of hoFont18 to True
            Set piColor of hoFont18 to XL_COLOR_GOLD
            Set pbStrikeOut of hoFont18 to True
            Set peUnderlineStyle of hoFont18 to XL_UNDERLINE_SINGLE
            // Ende Schriftarten festlegen
            
            // Formate fr 'normale' Zeilen festlegen
            Handle hoTextNoFormat hoTextFormat
            
            // Schriftart dem Format zuordnen
            Get AddFormat of hoBook to hoTextNoFormat
            Set phoFont of hoTextNoFormat to hoFont12

            Get Duplicate of hoTextNoFormat to hoTextFormat
            
            // Rahmen Farbe setzen
            Send SetBorderColor of hoTextFormat XL_COLOR_GOLD
            // Rahmen Art setzen
            Send SetBorderStyle of hoTextFormat XL_BORDERSTYLE_MEDIUM
            // Fullpattern Farbe setzen
            Set piPatternForegroundColor of hoTextFormat to XL_COLOR_LIGHTGREEN
            // Fullpattern setzen
            Set peFillPattern of hoTextFormat to XL_FILLPATTERN_SOLID
            
            Set phoFont of hoTextFormat to hoFont18
            
            // Zeilenumbruch aktivieren
            Set pbWrapText of hoTextFormat to True
            // Rotation auf 45E
            Set piRotation of hoTextFormat to 45
            
            // Spaltenbreite festlegen
            Set piColumnWidth of hoSheet 0 to 20    
            Set piColumnWidth of hoSheet 1 to 20    
            Set piColumnWidth of hoSheet 2 to 20    
            Set piColumnWidth of hoSheet 3 to 20    
            
            // Zeilenhhe festlegen
            Set piRowHeight of hoSheet to 0 100
            Set piRowHeight of hoSheet to 1 100
            Set piRowHeight of hoSheet to 2 100
            Set piRowHeight of hoSheet to 3 100
            Set piRowHeight of hoSheet to 4 100
            
            // Werte schreiben
            Send WriteStringWithFormat of hoSheet 0 0 "A1 Dataflex Entwicklertag" hoTextNoFormat
            Send WriteStringWithFormat of hoSheet 0 1 "B1 Dataflex Entwicklertag" hoTextFormat
            Send WriteStringWithFormat of hoSheet 0 2 "C1 Dataflex Entwicklertag" hoTextNoFormat
            Send WriteStringWithFormat of hoSheet 0 3 "D1 Dataflex Entwicklertag" hoTextFormat

            Send WriteStringWithFormat of hoSheet 1 0 "A2 Dataflex Entwicklertag" hoTextNoFormat
            Send WriteStringWithFormat of hoSheet 1 1 "B2 Dataflex Entwicklertag" hoTextFormat
            Send WriteStringWithFormat of hoSheet 1 2 "C2 Dataflex Entwicklertag" hoTextNoFormat
            Send WriteStringWithFormat of hoSheet 1 3 "D2 Dataflex Entwicklertag" hoTextFormat

            Send WriteStringWithFormat of hoSheet 2 0 "A3 Dataflex Entwicklertag" hoTextNoFormat
            Send WriteStringWithFormat of hoSheet 2 1 "B3 Dataflex Entwicklertag" hoTextFormat
            Send WriteStringWithFormat of hoSheet 2 2 "C3 Dataflex Entwicklertag" hoTextNoFormat
            Send WriteStringWithFormat of hoSheet 2 3 "D3 Dataflex Entwicklertag" hoTextFormat

            Send WriteStringWithFormat of hoSheet 3 0 "A4 Dataflex Entwicklertag" hoTextNoFormat
            Send WriteStringWithFormat of hoSheet 3 1 "B4 Dataflex Entwicklertag" hoTextFormat
            Send WriteStringWithFormat of hoSheet 3 2 "C4 Dataflex Entwicklertag" hoTextNoFormat
            Send WriteStringWithFormat of hoSheet 3 3 "D4 Dataflex Entwicklertag" hoTextFormat

            Send WriteStringWithFormat of hoSheet 4 0 "A5 Dataflex Entwicklertag" hoTextNoFormat
            Send WriteStringWithFormat of hoSheet 4 1 "B5 Dataflex Entwicklertag" hoTextFormat
            Send WriteStringWithFormat of hoSheet 4 2 "C5 Dataflex Entwicklertag" hoTextNoFormat
            Send WriteStringWithFormat of hoSheet 4 3 "D5 Dataflex Entwicklertag" hoTextFormat
            
            // Gruppierung
            Send GroupColumns of hoSheet 1 2 True
            Send GroupRows of hoSheet 1 2 True
            
            // Druckeinstellungen
            Set pePaper of hoSheet to XL_PAPER_A5
            Set pbLandscape of hoSheet to True
            
            // Zentrieren
            Set pbCenterHorizontally of hoSheet to True
            Set pbCenterVertically of hoSheet to True
            
            // SeitenrEder
            Set prMarginLeft of hoSheet to (CMToInch(1.5))
            Set prMarginRight of hoSheet to (CMToInch(1.6))
            Set prMarginBottom of hoSheet to (CMToInch(1.7))
            Set prMarginTop of hoSheet to (CMToInch(1.8))

//            // Druckbereich anpassen
//            Send SetPrintFit of hoSheet 0 0

    //  Code        Description
    //  &L	        specifies the beginning of the left section
    //  &P	        specifies the current page Number
    //  &N	        specifies the total Number of pages
    //  &\d{1,3}	specifies the text font size, where font size is measured in points, for example: &9 or &36
    //  &S	        specifies whether the strikethrough text style is on or off
    //  &X	        specifies whether the superscript text style is on or off
    //  &Y	        specifies whether the subscript text style is on or off
    
    //  &C	        specifies the beginning of the center section
    //  &D	        specifies a Date
    //  &T	        specifies a Time
    //  &G	        specifies a picture
    //  &U	        specifies whether the single underline text style is on or off
    //  &E	        specifies whether the double underline text style is on or off
    
    //  &R	        specifies the beginning of the right section
    //  &Z	        specifies a workbook file path
    //  &F	        specifies a workbook file name
    //  &a	        specifies a sheet name
    //  &"fontname"	specifies the text font, for example: &"Comic Sans MS"
    //  &B	        specifies whether the bold text style is on or off
    //  &I	        specifies whether the italic text style is on or off
    //  &&	        specifies an ampersand character (&)
            Set psHeaderText of hoSheet to "&CDataflex-Entwickler-Tag 2019"
            Set psFooterText of hoSheet to ("&L&D  &T &C&Z" + "\" + "&F&R&P" + "/" + "&N")
            // Arbeitsmappe sperren ohne Passwort
            //Set pbProtected of hoSheet to True
            // Arbeitsmappe sperren mit Passwort
            Set Protect of hoSheet to True "DataFlexEntwicklerTag" XL_PROT_DEFAULT
            
            //Send SetPrintArea of hoSheet 2 5 1 4
            
            Send SetPrintFit of hoSheet 2 3

            Send SaveAs of hoBook sFileName
            Send destroy to hoBook

            Handle hWnd hInstance
            Move (ShellExecute (hWnd, "open", sFileName, '', '', 0)) to hInstance
        End_Procedure
    End_Object
Cd_End_Object
