Use Windows.pkg
Use DFClient.pkg

Use cMyLibXL.pkg
Use cTextEdit.pkg
Use cCJGrid.pkg
Use cCJGridColumnRowIndicator.pkg
Use cCJGridColumn.pkg
Use ShellExecute.Pkg

Deferred_View Activate_oTabelleSchreibenUnformatiert for ;
Object oTabelleSchreibenUnformatiert is a dbView
    Set Border_Style to Border_Thick
    Set Size to 231 300
    Set Location to 2 2
    Set Label to "Tabelle Schreiben (unformatiert)"

    Property String[][] psArrayValues
    
    Object oLibXL is a cMyLibXL
    End_Object            

    Object oButtonXLSLesen is a Button
        Set Size to 14 104
        Set Location to 13 16
        Set Label to "XLS Lesen"
    
        Procedure OnClick
            String sFileName sValue
            String[][] sArrayValues
            Handle hoBook hoSheet hoSheets
            Integer iCol iCols iRow iRows
            
            Move ( (psDirectory(Self)) + "DemoLesen.xls" ) to sFileName
            
            Get Load of oLibXL sFileName to hoBook
            If (hoBook = 0) Begin
                Send Stop_Box ("Die Datei\n\n" + sFileName + "\n\nkonnte nicht gefunden werden") 
                Procedure_Return
            End
            If (hoBook <> 0) Begin
                Get SheetCount of hoBook to hoSheets
                Get Sheet of hoBook 0 to hoSheet
                If (hoSheet <> 0) Begin
                    Get LastRow of hoSheet to iRows
                    Get LastCol of hoSheet to iCols
                    For iRow from 0 to iRows
                        For iCol from 0 to iCols
                            Get ReadValue of hoSheet iRow iCol to sValue
                            Move sValue to sArrayValues[iRow][iCol]
                        Loop
                    Loop
                End
                Send Destroy of hoBook
                Set psArrayValues to sArrayValues
            End
            Send LoadData of oCJGrid
        End_Procedure
    End_Object

    Object oCJGrid is a cCJGrid
        Set Size to 181 268
        Set Location to 38 17
        Set peAnchors to anTopBottom

        Object oCJGridColumnRowIndicator1 is a cCJGridColumnRowIndicator
        End_Object

        Object oCJGridColumn1 is a cCJGridColumn
            Set piWidth to 100
            Set psCaption to "column 1"
        End_Object

        Object oCJGridColumn2 is a cCJGridColumn
            Set piWidth to 100
            Set psCaption to "column 2"
        End_Object

        Object oCJGridColumn3 is a cCJGridColumn
            Set piWidth to 100
            Set psCaption to "column 3"
        End_Object

        Object oCJGridColumn4 is a cCJGridColumn
            Set piWidth to 100
            Set psCaption to "column 4"
        End_Object
        
        Procedure LoadData
            Integer iCol1 iCol2 iCol3 iCol4
            String[][] sArrayValues
            tDataSourceRow[] TheData
            Integer iCol iCols
            Integer iRow iRows
            
            Get piColumnId of oCJGridColumn1 to iCol1
            Get piColumnId of oCJGridColumn2 to iCol2
            Get piColumnId of oCJGridColumn3 to iCol3
            Get piColumnId of oCJGridColumn4 to iCol4
            
            Get psArrayValues to sArrayValues
            Move (SizeOfArray(sArrayValues)) to iRows
            For iRow from 0 to (iRows-1)
                Move sArrayValues[iRow][0] to TheData[iRow].sValue[1]
                Move sArrayValues[iRow][1] to TheData[iRow].sValue[2]
                Move sArrayValues[iRow][2] to TheData[iRow].sValue[3]
                Move sArrayValues[iRow][3] to TheData[iRow].sValue[4]
            Loop
            Send InitializeData TheData
        End_Procedure
    End_Object

    Object oButtonTabelleSchreibenUnformatiert is a Button
        Set Size to 14 104
        Set Location to 13 123
        Set Label to "XLSX Schreiben (unformatiert)"
        
        Procedure OnClick
            String sFileName
            Handle hoBook hoSheet 
            String[][] sArrayValues
            Integer iRow iRows
            Boolean bFileExists
            
            Get psArrayValues to sArrayValues

            Move ( (psDirectory(Self)) + "DemoSchreibenUnformatiert.xlsx" ) to sFileName
            
            // Alte Xlsx lschen
            File_Exist sFileName bFileExists
            If (bFileExists) Begin
                EraseFile sFileName
            End
            
            // Datei erstellen
            Get CreateXMLBook of oLibXL to hoBook
            // Sheet erstellen
            Get AddSheet of hoBook "Demo (unformatiert)" to hoSheet

            // Spaltenbreite festlegen
            Set piColumnWidth of hoSheet 0 to 20    
            Set piColumnWidth of hoSheet 1 to 20    
            Set piColumnWidth of hoSheet 2 to 20    
            Set piColumnWidth of hoSheet 3 to 20    
    
            Move (SizeOfArray(sArrayValues)) to iRows
            For iRow from 0 to (iRows-1)
                Send WriteString of hoSheet iRow 0 sArrayValues[iRow][0]
                Send WriteString of hoSheet iRow 1 sArrayValues[iRow][1]
                Send WriteString of hoSheet iRow 2 sArrayValues[iRow][2]
                Send WriteString of hoSheet iRow 3 sArrayValues[iRow][3]
            Loop

            Send SaveAs of hoBook sFileName
            Send destroy to hoBook
            Send Info_Box ("Die Datei" * sFileName * "wurde erstellt")
        End_Procedure
    End_Object

    Object oButtonXLSOeffnen is a Button
        Set Location to 13 235
        Set Label to "XLSX ffnen"
    
        Procedure OnClick
            Handle hWnd hInstance
            String sFileName

            Move ( (psDirectory(Self)) + "DemoSchreibenUnformatiert.xlsx" ) to sFileName
            Move (ShellExecute (hWnd, "open", sFileName, '', '', 0)) to hInstance
        End_Procedure
    End_Object
Cd_End_Object
