Use Windows.pkg
Use DFClient.pkg

Use cMyLibXL.pkg
Use cTextEdit.pkg
Use cCJGrid.pkg
Use cCJGridColumnRowIndicator.pkg
Use cCJGridColumn.pkg
Use ShellExecute.Pkg

Deferred_View Activate_oTabelleSchreibenFormatiert for ;
Object oTabelleSchreibenFormatiert is a dbView
    Set Border_Style to Border_Thick
    Set Size to 231 300
    Set Location to 2 2
    Set Label to "Tabelle Schreiben (formatiert)"
    
    Property String[][] psArrayValues
    
    Object oLibXL is a cMyLibXL
    End_Object            

    Object oButtonXLSLesen is a Button
        Set Size to 14 104
        Set Location to 13 16
        Set Label to "XLS Lesen"
    
        Procedure OnClick
            String sFileName sValue
            String[][] sArrayValues
            Handle hoBook hoSheet hoSheets
            Integer iCol iCols iRow iRows
            
            Move ( (psDirectory(Self)) + "DemoLesen.xls" ) to sFileName
            
            Get Load of oLibXL sFileName to hoBook
            If (hoBook = 0) Begin
                Send Stop_Box ("Die Datei\n\n" + sFileName + "\n\nkonnte nicht gefunden werden") 
                Procedure_Return
            End
            If (hoBook <> 0) Begin
                Get SheetCount of hoBook to hoSheets
                Get Sheet of hoBook 0 to hoSheet
                If (hoSheet <> 0) Begin
                    Get LastRow of hoSheet to iRows
                    Get LastCol of hoSheet to iCols
                    For iRow from 0 to iRows
                        For iCol from 0 to iCols
                            Get ReadValue of hoSheet iRow iCol to sValue
                            Move sValue to sArrayValues[iRow][iCol]
                        Loop
                    Loop
                End
                Send Destroy of hoBook
                Set psArrayValues to sArrayValues
            End
            Send LoadData of oCJGrid
        End_Procedure
    End_Object

    Object oCJGrid is a cCJGrid
        Set Size to 181 268
        Set Location to 38 17
        Set peAnchors to anTopBottom

        Object oCJGridColumnRowIndicator1 is a cCJGridColumnRowIndicator
        End_Object

        Object oCJGridColumn1 is a cCJGridColumn
            Set piWidth to 100
            Set psCaption to "column 1"
        End_Object

        Object oCJGridColumn2 is a cCJGridColumn
            Set piWidth to 100
            Set psCaption to "column 2"
        End_Object

        Object oCJGridColumn3 is a cCJGridColumn
            Set piWidth to 100
            Set psCaption to "column 3"
        End_Object

        Object oCJGridColumn4 is a cCJGridColumn
            Set piWidth to 100
            Set psCaption to "column 4"
        End_Object
        
        Procedure LoadData
            Integer iCol1 iCol2 iCol3 iCol4
            String[][] sArrayValues
            tDataSourceRow[] TheData
            Integer iCol iCols
            Integer iRow iRows
            
            Get piColumnId of oCJGridColumn1 to iCol1
            Get piColumnId of oCJGridColumn2 to iCol2
            Get piColumnId of oCJGridColumn3 to iCol3
            Get piColumnId of oCJGridColumn4 to iCol4
            
            Get psArrayValues to sArrayValues
            Move (SizeOfArray(sArrayValues)) to iRows
            For iRow from 0 to (iRows-1)
                Move sArrayValues[iRow][0] to TheData[iRow].sValue[1]
                Move sArrayValues[iRow][1] to TheData[iRow].sValue[2]
                Move sArrayValues[iRow][2] to TheData[iRow].sValue[3]
                Move sArrayValues[iRow][3] to TheData[iRow].sValue[4]
            Loop
            Send InitializeData TheData
        End_Procedure
    End_Object

    Object oButtonTabelleSchreibenFormatiert is a Button
        Set Size to 14 104
        Set Location to 13 123
        Set Label to "XLSX Schreiben (formatiert)"
        
        Procedure OnClick
            String sFileName
            Handle hoBook hoSheet 
            String[][] sArrayValues
            Integer iRow iRows
            Boolean bFileExists
            
            // Datei erstellen
            Get CreateXMLBook of oLibXL to hoBook
            // Sheet erstellen
            Get AddSheet of hoBook "Demo (formatiert)" to hoSheet
            
            // Schriftartenformate festlegen
            Handle hoFont10 hoFont10Bold hoFont12 hoFont12Bold
            
            Get AddFont of hoBook "Arial" 10 to hoFont10
            Get AddFont of hoBook "Arial" 10 True to hoFont10Bold

            Get AddFont of hoBook "Arial" 12 to hoFont12
            Get AddFont of hoBook "Arial" 12 True to hoFont12Bold
            // Ende Schriftarten festlegen
            
            // Formate fr 'normale' Zeilen festlegen
            Handle hoTextFormat hoTextFormatLeft hoTextFormatCenter hoTextFormatRight
            
            // Schriftart dem Format zuordnen
            Get AddFormat of hoBook to hoTextFormat
            Set phoFont of hoTextFormat to hoFont10
            
            // Linksbndiges Textformat erstellen
            Get Duplicate of hoTextFormat to hoTextFormatLeft
            Set peAlignH of hoTextFormatLeft to XL_ALIGNH_LEFT
            Set peAlignV of hoTextFormatLeft to XL_ALIGNV_CENTER
            
            // Zentriertes Textformat erstellen
            Get Duplicate of hoTextFormat to hoTextFormatCenter
            Set peAlignH of hoTextFormatCenter to XL_ALIGNH_CENTER
            Set peAlignV of hoTextFormatCenter to XL_ALIGNV_CENTER
            
            // Rechtsbndigeses Textformat erstellen
            Get Duplicate of hoTextFormat to hoTextFormatRight
            Set peAlignH of hoTextFormatRight to XL_ALIGNH_RIGHT
            Set peAlignV of hoTextFormatRight to XL_ALIGNV_CENTER
            // Ende Formate fr 'normale' Zeilen festlegen
            
            // Formate fr berschriften festlegen
            Handle hoHeaderFormatLeft hoHeaderFormatCenter hoHeaderFormatRight
            
            Get Duplicate of hoTextFormatLeft to hoHeaderFormatLeft
            Set phoFont of hoHeaderFormatLeft to hoFont12Bold
            
            Get Duplicate of hoTextFormatCenter to hoHeaderFormatCenter
            Set phoFont of hoHeaderFormatCenter to hoFont12Bold
            
            Get Duplicate of hoTextFormatRight to hoHeaderFormatRight
            Set phoFont of hoHeaderFormatRight to hoFont12Bold
            // Ende Formate fr berschriften festlegen
            
            // Zahlenformate festlegen
            Handle ho0DezimalstellenFormat ho2DezimalstellenFormat 
            // 0 Nachkommastellen
            
            Get Duplicate of hoTextFormat to ho0DezimalstellenFormat
            Set peNumFormat of ho0DezimalstellenFormat to (AddCustomNumFormat(hoBook, "###,##0"))
            
            // 2 Nachkommastellen
            Get Duplicate of hoTextFormat to ho2DezimalstellenFormat
            Set peNumFormat of ho2DezimalstellenFormat to (AddCustomNumFormat(hoBook, "###,##0.00"))
            
            // Summenzahlenformate
            Handle ho0DezimalstellenFormatBold ho2DezimalstellenFormatBold
            // 0 Nachkommastellen
            
            Get Duplicate of hoTextFormat to ho0DezimalstellenFormatBold
            Set phoFont of ho0DezimalstellenFormatBold to hoFont12Bold
            Set peNumFormat of ho0DezimalstellenFormatBold to (AddCustomNumFormat(hoBook, "###,##0"))
            
            // 2 Nachkommastellen
            Get Duplicate of hoTextFormat to ho2DezimalstellenFormatBold
            Set phoFont of ho2DezimalstellenFormatBold to hoFont12Bold
            Set peNumFormat of ho2DezimalstellenFormatBold to (AddCustomNumFormat(hoBook, "###,##0.00"))
            // Ende Zahlenformate festlegen
            
            Get psArrayValues to sArrayValues

            Move ( (psDirectory(Self)) + "DemoSchreibenUnformatiert.xlsx" ) to sFileName
            // Alte Xlsx lschen
            File_Exist sFileName bFileExists
            If (bFileExists) Begin
                EraseFile sFileName
            End
            
            // Spaltenbreite festlegen
            Set piColumnWidth of hoSheet 0 to 20    
            Set piColumnWidth of hoSheet 1 to 20    
            Set piColumnWidth of hoSheet 2 to 20    
            Set piColumnWidth of hoSheet 3 to 20    
    
            // Zellen zusammenfassen fr berschrift
            Send MergeCells of hoSheet 0 0 0 3

            Move (SizeOfArray(sArrayValues)) to iRows
            For iRow from 0 to (iRows-1)
                // Allgemeine berschrift
                If (iRow = 0) Begin
                    Send WriteStringWithFormat of hoSheet iRow 0 sArrayValues[iRow][0] hoHeaderFormatLeft
                End
                // Tabellenberschriften
                Else If (iRow = 2) Begin
                    Send WriteStringWithFormat of hoSheet iRow 0 sArrayValues[iRow][0] hoHeaderFormatLeft
                    Send WriteStringWithFormat of hoSheet iRow 1 sArrayValues[iRow][1] hoHeaderFormatRight
                    Send WriteStringWithFormat of hoSheet iRow 2 sArrayValues[iRow][2] hoHeaderFormatRight
                    Send WriteStringWithFormat of hoSheet iRow 3 sArrayValues[iRow][3] hoHeaderFormatRight
                End
                // Summenzeilen
                Else If (iRow = (iRows-2)) Begin
                    Send WriteStringWithFormat of hoSheet iRow 0 sArrayValues[iRow][0] hoHeaderFormatLeft
                    Send WriteNumberWithFormat of hoSheet iRow 1 sArrayValues[iRow][1] ho2DezimalstellenFormatBold
                    Send WriteNumberWithFormat of hoSheet iRow 2 sArrayValues[iRow][2] ho0DezimalstellenFormatBold
                    Send WriteNumberWithFormat of hoSheet iRow 3 sArrayValues[iRow][3] ho2DezimalstellenFormatBold
                End
                // Weitere Zeilen
                Else Begin
                    Send WriteStringWithFormat of hoSheet iRow 0 sArrayValues[iRow][0] hoHeaderFormatLeft
                    Send WriteNumberWithFormat of hoSheet iRow 1 sArrayValues[iRow][1] ho2DezimalstellenFormat
                    Send WriteNumberWithFormat of hoSheet iRow 2 sArrayValues[iRow][2] ho0DezimalstellenFormat
                    Send WriteNumberWithFormat of hoSheet iRow 3 sArrayValues[iRow][3] ho2DezimalstellenFormat
                End
            Loop

            Send SaveAs of hoBook sFileName
            Send destroy to hoBook
            Send Info_Box ("Die Datei" * sFileName * "wurde erstellt")
        End_Procedure
    End_Object

    Object oButtonXLSOeffnen is a Button
        Set Location to 13 235
        Set Label to "XLSX ffnen"
    
        Procedure OnClick
            Handle hWnd hInstance
            String sFileName

            Move ( (psDirectory(Self)) + "DemoSchreibenUnformatiert.xlsx" ) to sFileName
            Move (ShellExecute (hWnd, "open", sFileName, '', '', 0)) to hInstance
        End_Procedure
    End_Object
Cd_End_Object
